var th = [ '', MESSAGE_BUNDLE['core.thousand'], MESSAGE_BUNDLE['core.million'], MESSAGE_BUNDLE['core.billion'], MESSAGE_BUNDLE['core.trillion'] ];
var dg = [ MESSAGE_BUNDLE['core.zero'], MESSAGE_BUNDLE['core.one'], MESSAGE_BUNDLE['core.two'], MESSAGE_BUNDLE['core.three'], MESSAGE_BUNDLE['core.four'], 
	MESSAGE_BUNDLE['core.five'], MESSAGE_BUNDLE['core.six'], MESSAGE_BUNDLE['core.seven'], MESSAGE_BUNDLE['core.eight'], MESSAGE_BUNDLE['core.nine'] ];
var tn = [ MESSAGE_BUNDLE['core.ten'], MESSAGE_BUNDLE['core.eleven'], MESSAGE_BUNDLE['core.twelve'], MESSAGE_BUNDLE['core.thirteen'], MESSAGE_BUNDLE['core.fourteen'],
	MESSAGE_BUNDLE['core.fifteen'], MESSAGE_BUNDLE['core.sixteen'], MESSAGE_BUNDLE['core.seventeen'], MESSAGE_BUNDLE['core.eighteen'], MESSAGE_BUNDLE['core.nineteen'] ];
var tw = [ MESSAGE_BUNDLE['core.twenty'], MESSAGE_BUNDLE['core.thirty'], MESSAGE_BUNDLE['core.fourty'], MESSAGE_BUNDLE['core.fifty'], 
	MESSAGE_BUNDLE['core.sixty'], MESSAGE_BUNDLE['core.seventy'], MESSAGE_BUNDLE['core.eighty'], MESSAGE_BUNDLE['core.ninety'] ];



var specsMoneyUtil = {
	moneyParam : {
		format : "#,##0.00",
		locale : "us"
	},
	currency : {
		symbol : "&#x20A6;",
		name : "Naira",
		koboName : "Kobo"
	},

	parseMoney : function(selector) {
		$(selector).each(function(i) {
			$(this).val(getMoneyValue($(this).val()));
		});
	},
	getMoneyValue : function(value) {
		return $.parseNumber(value, specsMoneyUtil.moneyParam);
	},
	getFormattedMoney : function(money) {
		return $.formatNumber(money, specsMoneyUtil.moneyParam);
	},
	formatMoney : function(ctrl) {
		if (specsMoneyUtil.isValidNumber($(ctrl).val())) {
			$(ctrl).val(ctrl.value.replace(/\,/g, ""));
			$(ctrl).formatNumber(specsMoneyUtil.moneyParam);
		}
	},
	isValidNumber : function(number) {
		return !isNaN(number.replace(/\,/g, ""));
	},
	isDigit : function(number) {
		var isDigit = false;
		try {
			var decimals = number.match(/\./g);
			isDigit = specsMoneyUtil.isValidNumber(number) && (decimals == null || decimals.length == 0);
		} catch (err) {
		}
		return isDigit;
	},
	isDigitOnly : function(number) {
		var isDigit = false;
		try {
			var decimals = number.match(/\./g);
			isDigit = specsMoneyUtil.isValidNumberOnly(number) && (decimals == null || decimals.length == 0);
		} catch (err) {
		}
		return isDigit;
	},
	isValidNumberOnly : function(number) {
		return !isNaN(number);
	},

	tokenToWords : function tokenToWords(s) {
		var n = s.split('');
		var x = s.length;
		var str = '';
		var sk = 0;
		for (var i = 0; i < x; i++) {
			if (x > 3 && i == x - 3) {
				if (n[i] == '0') {
					str += MESSAGE_BUNDLE['core.and'];
				}
			}
			if ((x - i) % 3 == 2) {
				if (n[i] == '1') {
					str += tn[Number(n[i + 1])] + ' ';
					i++;
					sk = 1;
				} else if (n[i] != 0) {
					str += tw[n[i] - 2] + ' ';
					sk = 1;
				}
			} else if (n[i] != 0) {
				str += dg[n[i]] + ' ';
				if ((x - i) % 3 == 0) {
					str += MESSAGE_BUNDLE['core.hundred'];
					if (n[i + 1] != '0' || n[i + 2] != '0') {
						str += MESSAGE_BUNDLE['core.and'];
					}
				}
				sk = 1;
			}
			if ((x - i) % 3 == 1) {
				if (sk) {
					var cth = th[(x - i - 1) / 3];
					str += cth + (cth == '' ? '' : ', ');
				}
				sk = 0;
			}
		}
		return str;
	},

	toWords : function toWords(s) {
		s = s.toString();
		s = s.replace(/[\, ]/g, '');
		if (s != parseFloat(s))
			return MESSAGE_BUNDLE['core.not.a.number'];
		var x = s.indexOf('.');
		var y = x;
		if (x == -1)
			x = s.length;
		if (x > 15)
			return MESSAGE_BUNDLE['core.too.big'];
		var wn = s.substring(0, x);
		var str = specsMoneyUtil.tokenToWords(wn) + specsMoneyUtil.currency.name;
		if (y != -1) {
			var fr = s.substring(y + 1);
			fr = fr.length == 1 ? fr + '0' : fr.substring(0, 2);
			if (!(fr[0] == '0' && fr[1] == '0')) {
				str += ', ' + specsMoneyUtil.tokenToWords(fr) + specsMoneyUtil.currency.koboName;
			}
		}
		str += MESSAGE_BUNDLE['core.only'] ;
		// fix for bug
		str = str.replace(MESSAGE_BUNDLE['core.comma.and'] + specsMoneyUtil.currency.name, ' ' + specsMoneyUtil.currency.name);
		// fix for bug
		str = str.replace(MESSAGE_BUNDLE['core.and']+ specsMoneyUtil.currency.name, ' ' + specsMoneyUtil.currency.name);
		return str.replace(/\s+/g, ' ');
	},
	init : function(options) {
		this.currency.symbol = options.currencySymbol;
		this.currency.name = options.currencyName;
		this.currency.koboName = options.currencyKoboName;
	}
};