<?php

if (!defined('BASEPATH')){
    exit('No direct script access allowed');
}

class Client extends Admin_Controller  {

    function __construct() {
        parent::__construct();
        $this->load->helper('form');
    }


    public function list($page = 'index')
    {
        if ( ! file_exists(APPPATH.'views/admin/addon/client/'.$page.'.php'))
        {
                // Whoops, we don't have a page for that!
                show_404();
        }
        
        $this->session->set_userdata('top_menu', 'Clients');
        $this->session->set_userdata('sub_menu', 'client/list');
        $data['title'] = 'Add Client';
        $data['title_list'] = 'Recent Clients';
        $this->load->view('layout/header', $data);
        $this->load->view('admin/addon/client/index', $data);
        $this->load->view('layout/footer', $data);

    }

    public function create() {
        $this->session->set_userdata('top_menu', 'Clients');
        $this->session->set_userdata('sub_menu', 'client/list');
        $data['title'] = 'Add Client';
        $data['title_list'] = 'Recent Clients';
        $roles = $this->role_model->get();
        $data['roles'] = $roles;

        // $itemcategory = $this->itemcategory_model->get();
        // $data['itemcatlist'] = $itemcategory;
        // $data['staff'] = $this->staff_model->inventry_staff();

        $this->load->view('layout/header', $data);
        $this->load->view('admin/addon/client/create', $data);
        $this->load->view('layout/footer', $data);
    }

    public function getclientlist()
    {
        $m       = $this->client_model->getclientlist();
        $m       = json_decode($m);
        $dt_data = array();
        if (!empty($m->data)) {
            foreach ($m->data as $key => $value) {
                $editbtn   = '';
                $deletebtn = '';
                $documents = '' ;
             
                $is_active=" <span class='label label-success'>Active</span>" ;

             
                if ($this->rbac->hasPrivilege('issue_item', 'can_delete')) {
                    $deletebtn = '';
                    $deletebtn = "<a onclick='return confirm(" . '"' . $this->lang->line('delete_confirm') . '"' . "  )' href='".base_url()."admin/issueitem/delete/".$value->id."' class='btn btn-default btn-xs' data-placement='left' title='" . $this->lang->line('delete') . "' data-toggle='tooltip'><i class='fa fa-remove'></i></a>";
                }

                if ($value->name == "") { 
                    $condition = "<p class='text text-danger no-print'>".$this->lang->line('no_description')." </p>" ;
                 }else{
                    $condition = "<p class='text text-info no-print' >".$value->name."</p>" ;
                 }

             
                if ($this->rbac->hasPrivilege('issue_item', 'can_delete')) {
                    $deletebtn = '';
                    $deletebtn = "<a onclick='return confirm(" . '"' . $this->lang->line('delete_confirm') . '"' . "  )' href='".base_url()."admin/issueitem/delete/".$value->id."' class='btn btn-default btn-xs' data-placement='left' title='" . $this->lang->line('delete') . "' data-toggle='tooltip'><i class='fa fa-remove'></i></a>";
                }
             
                if(ENVIRONMENT == 'production'){
                    $str = "https://".$value->subdomain.".".DOMAIN;
                }else{
                    $str = "http://".$value->subdomain.".".DOMAIN;
                }
                $url_pattern = '/(http|https|ftp|ftps)\:\/\/[a-zA-Z0-9\-\.]+\.[a-zA-Z]{2,3}(\/\S*)?/';   
                $url= preg_replace($url_pattern, '<a target="_blank" href="$0">$0</a>', $str);
                
                $row       = array();
                $row[]     =  $key + 1; 
                $row[]     =  $value->name;
                $row[]     =  $url;
                $row[]     =  $is_active ;
                $row[]     =  $deletebtn;
                $dt_data[] = $row;
            }
        }

        $json_data = array(
            "draw"            => intval($m->draw),
            "recordsTotal"    => intval($m->recordsTotal),
            "recordsFiltered" => intval($m->recordsFiltered),
            "data"            => $dt_data,
        );
        echo json_encode($json_data);
    }

    public function recurseCopy($src,$dst, $childFolder='') { 

        $dir = opendir($src); 
        mkdir($dst, 0777, true);
        // chmod($dst,755); dangerous
        if ($childFolder!='') {
            mkdir($dst.'/'.$childFolder);
    
            while(false !== ( $file = readdir($dir)) ) { 
                if (( $file != '.' ) && ( $file != '..' )) { 
                    if ( is_dir($src . '/' . $file) ) { 
                        $this->recurseCopy($src . '/' . $file,$dst.'/'.$childFolder . '/' . $file); 
                    } 
                    else { 
                        copy($src . '/' . $file, $dst.'/'.$childFolder . '/' . $file); 
                    }  
                } 
            }
        }else{
                // return $cc; 
            while(false !== ( $file = readdir($dir)) ) { 
                if (( $file != '.' ) && ( $file != '..' )) { 
                    if ( is_dir($src . '/' . $file) ) { 
                        $this->recurseCopy($src . '/' . $file,$dst . '/' . $file); 
                    } 
                    else { 
                        copy($src . '/' . $file, $dst . '/' . $file); 
                    }  
                } 
            } 
        }
        
        closedir($dir); 
    }

    function add() {
        
        $this->form_validation->set_rules('client_name', $this->lang->line('school_name'), 'required|trim|xss_clean');
        $this->form_validation->set_rules('subdomain', $this->lang->line('slug'), 'required|trim|xss_clean');

        if ($this->form_validation->run() == false) {
            $data = array(
                'client_name' => form_error('client_name'),
                'subdomain' => form_error('subdomain'),
            );
            $array = array('status' => 'fail', 'error' => $data);
            echo json_encode($array);
        } else {
            $prefix = "basicng_";

            if(ENVIRONMENT !== 'production'){
                $prefix = "";
            }
            // UG16/SCCS/1015
            $db_name = $prefix.$this->input->post('subdomain');

            $data = array(
                'name' => $this->input->post('client_name'),
                'subdomain' => $this->input->post('subdomain'),
                'dbname' => $db_name,
            );
            
            if($this->client_model->add($data)){
            
            /* Store the path of source file */
             $filePath = 'temp/uploads'; 
            /* Store the path of destination file */
        
            $destinationFilePath = 'uploads/clients/'.$this->input->post('subdomain').'/uploads';
            
            if(!file_exists($destinationFilePath)){
                $this->recurseCopy($filePath, $destinationFilePath); 
            }
            
            // uploadS3Image($key_path,$image_path);
            // https://aryamagazine.in/get-started-with-amazon-aws-s3-bucket-set-up-in-codeigniter/
                        //   uploadS3Image("room1.jpeg", "uploads"); //Testing AWS3
            //
            $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('success_message'));
            echo json_encode($array);
        }
    }
        }

    }

?>


