<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Remita extends CI_Controller {

    public function __construct() {
        parent::__construct();
        // $this->model_type = 2;
        $this->pay_method = $this->paymentsetting_model->getActiveMethod();
        $this->load->library('mailsmsconf');
        $this->load->model(array('paymentsetting_model', 'customfield_model', 'onlinestudent_model' ));

    }

        //Made to be used by webhook and other calls for rrr like confirm rrr
        public function remita_payment_status() // Remita
        {
           
            /* 
             * Collected Post Request From remita.net
            */
            if(isset($_GET['txref'])){
    
                $remitaInvoices        = $this->onlinestudent_model->getRemitaInvoices($_GET['txref']); 
           
            }else{
                // Find out how remita send thir webhook request (POST or GET). and the parameters
                // $rrr                        =   $request[0]['rrr'];
                // $remitaInvoices        = $this->onlinestudent_model->getRemitaInvoicesRrr($rrr);
            }
            
           
    
            if($remitaInvoices){
              
                $reference = $remitaInvoices->payer_id; //Online Admission Id
                $txref     = $remitaInvoices->transaction_ref;
                $params    = $remitaInvoices->params;
               
                if($remitaInvoices->payer_model_type == 1){
    
                    // redirect(base_url() . "onlineadmission/remita/complete?disappear=$reference&txref=$txref");
                    redirect(base_url() . "remita/complete?disappear=$reference&txref=$txref");
    
                }else if($remitaInvoices->payer_model_type == 2){
                    
                    // redirect(base_url() . "students/remita/success?txref=$txref&params=$params");
                    redirect(base_url() . "remita/success?txref=$txref&params=$params");
    
            }
        } 
    }
    
    //Update Online Admission Webhook
    public function complete()
    {
        $details        = $this->paymentsetting_model->getActiveMethod();
        $api_secret_key = $details->api_secret_key;
        $reference  = $this->session->userdata('reference');
        $txref = $_GET['txref']; //This is Student ID also payer id provided payer model type = 1
        
        if($reference == ''){
            $reference = $_GET['disappear']; //This is Online Admission ID also payer id provided payer model type = 1
        }
        
        $online_data = $this->onlinestudent_model->getAdmissionData($reference);
        $apply_date=date("Y-m-d H:i:s");
        $date         = date($this->customlib->getSchoolDateFormat(), $this->customlib->dateyyyymmddTodateformat($apply_date));
        $amount = $this->amount; // Update by me KB
        /*
        |-----------------------------------------------------------------------------------------------------------------------------
        |  Client's REMITA Certified Merchant API Details
        |-----------------------------------------------------------------------------------------------------------------------------
        |
        | These are client details collected from remita and calling from RemitaMerchantInfo Model 
        | 
        |
        */
        $merchantId         = $this->pay_method->api_publishable_key;
        $apiKey             = $this->pay_method->api_secret_key;         
        /*
        |-------------------------------------------------------------------------------------------------
        | Remita API's Code
        |-------------------------------------------------------------------------------------------------
        |
        | The following code was given by remita except we put the needed values where necessary 
        |
        */

        define("MERCHANTID", $merchantId); 
        define("APIKEY", $apiKey);
        define("CHECKSTATUSURL", "https://login.remita.net/remita/ecomm");
   
      //Verify Transaction
      function remita_transaction_details($orderIdStatus){
                
        $mert =  MERCHANTID;
        $api_key =  APIKEY;
        $concatString = $orderIdStatus . $api_key . $mert;
        $hash = hash('sha512', $concatString);
        $url 	= CHECKSTATUSURL . '/' . $mert  . '/' . $orderIdStatus . '/' . $hash . '/' . 'orderstatus.reg';
        //  Initiate curl
        $ch = curl_init();
        // Disable SSL verification
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        // Will return the response, if false it print the response
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // Set the url
        curl_setopt($ch, CURLOPT_URL,$url);
        // Execute
        $result=curl_exec($ch);
        // Closing
        curl_close($ch);
        $response = json_decode($result, true);
        return $response;
    } 

        $remitaInvoices        = $this->onlinestudent_model->getRemitaInvoices($txref);
        $rrr = $remitaInvoices->rrr_number;

        if($remitaInvoices){

            $orderId               = $remitaInvoices->rrrOrderId;
            $currentRrrStatus      = $remitaInvoices->rrr_status;
            $response              = remita_transaction_details($orderId);
            
            if(isset($response['status'])){

                    $response_code      = $response['status'];
                    $response_message   = $response['message'];
                        // if (isset($response['RRR'])){
                        //     $rrr = $response['RRR'];
                        // }
        
                $chargeResponsecode    = $response['status'];
                $chargeAmount          = $response['amount'];
                  
                    
                if (($chargeResponsecode == "00" || $chargeResponsecode == "01")) {
                    
                        $transactionid                      = $orderId;
                        $gateway_response['paid_amount']    = $chargeAmount;
                        $gateway_response['admission_id']   = $reference;
                        $gateway_response['transaction_id'] = $transactionid;
                        $gateway_response['payment_mode']   = 'remita';
                        $gateway_response['payment_type']   = 'online';
                        $gateway_response['note']           = "Payment deposit through Remita TXN ID: " . $transactionid;
                        $gateway_response['total_amount']   = $chargeAmount;

                        $paymentDateFull    =   $response['paymentDate'];
                        $paymentDate        =   substr($paymentDateFull, 0, 10);   
                        $paymentTime        =   substr($paymentDateFull, 11);   
                        $paymentAmount      =   $chargeAmount;
                        
                       
                    // if($currentRrrStatus == 025){//Update Just Once is not updated before
                        /**
                        * Update Remits Invoice Model
                        */
                            $remita_response = [
                                'payer_id'         => $reference,
                                'payer_model_type' => 1,
                                'rrrOrderId'       => $transactionid,
                                'rrr_number'       => $rrr,
                                'payment_date'     => $paymentDate,
                                'payment_time'     => $paymentTime,
                                'rrr_status'       => '01',
                                'payment_status'   => '1',
                                'total_amount_paid'=> $paymentAmount,
                                'transaction_ref'  => $txref
                            ];

                        $updateRemitaInvoices    = $this->onlinestudent_model->paymentRemitaSuccess($remita_response);
                    

                    $return_detail     = $this->onlinestudent_model->paymentSuccess($gateway_response);
                    $sender_details = array('firstname' => $online_data->firstname, 'lastname' => $online_data->lastname, 'email' => $online_data->email,'date'=>$date,'reference_no'=>$online_data->reference_no,'mobileno'=>$online_data->mobileno,'paid_amount'=>$amount);
                    $this->mailsmsconf->mailsms('online_admission_fees_submission', $sender_details);
                // }
                    redirect(base_url("onlineadmission/checkout/successinvoice/".$online_data->reference_no));
                    
                   
             }
                redirect(base_url("onlineadmission/checkout/paymentfailed/".$online_data->reference_no));
            } else {
                redirect(base_url("onlineadmission/checkout/paymentfailed/".$online_data->reference_no));
              }
        } 
        
        else {
            die('No or Invalied reference supplied');
        }
    }

    //School Fees Webhook
    public function success() {
        
        $details = $this->paymentsetting_model->getActiveMethod();
        $api_secret_key = $details->api_secret_key;
        
        if($this->session->userdata('params') == ''){
            // https://stackoverflow.com/questions/10686333/save-array-in-mysql-database
            $params =  unserialize($_GET['params']);
        }else{
            $params = $this->session->userdata('params');
        }
        
        $txref = $_GET['txref']; //This is Student ID also payer id provided payer model type = 1

         /*
        |-----------------------------------------------------------------------------------------------------------------------------
        |  Client's REMITA Certified Merchant API Details
        |-----------------------------------------------------------------------------------------------------------------------------
        |
        | These are client details collected from remita and calling from RemitaMerchantInfo Model 
        | 
        |
        */
        $merchantId         = $details->api_publishable_key;
        $apiKey             = $details->api_secret_key;         
        

    //    if (isset($_GET['txref'])) {
    //     if(isset($_GET['cancelled']) && $_GET['cancelled']=='true'){
    //         redirect(base_url("students/payment/paymentfailed"));
    //     }else{

        // $ref = $_GET['txref'];
        $amount=number_format((float)($params['fine_amount_balance']+$params['total']), 2, '.', ''); //Get the correct amount of your product
        $currency = $params['invoice']->currency_name; //Correct Currency from Server

        /*
        |-------------------------------------------------------------------------------------------------
        | Remita API's Code
        |-------------------------------------------------------------------------------------------------
        |
        | The following code was given by remita except we put the needed values where necessary 
        |
        */

        define("MERCHANTID", $merchantId); 
        define("APIKEY", $apiKey);
        define("CHECKSTATUSURL", "https://login.remita.net/remita/ecomm");
       
       
       //Verify Transaction
      function remita_transaction_details($orderIdStatus){
                
        $mert =  MERCHANTID;
        $api_key =  APIKEY;
        $concatString = $orderIdStatus . $api_key . $mert;
        $hash = hash('sha512', $concatString);
        $url 	= CHECKSTATUSURL . '/' . $mert  . '/' . $orderIdStatus . '/' . $hash . '/' . 'orderstatus.reg';
        //  Initiate curl
        $ch = curl_init();
        // Disable SSL verification
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        // Will return the response, if false it print the response
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // Set the url
        curl_setopt($ch, CURLOPT_URL,$url);
        // Execute
        $result=curl_exec($ch);
        // Closing
        curl_close($ch);
        $response = json_decode($result, true);
        return $response;
    } 

    $remitaInvoices        = $this->onlinestudent_model->getRemitaInvoices($txref);
    
        if($remitaInvoices){
           
            if($remitaInvoices->payment_status == 1) { // Avoid multiple update    
                redirect(base_url("students/payment/successinvoice"));
            }
            $orderId               = $remitaInvoices->rrrOrderId;
            $currentRrrStatus      = $remitaInvoices->rrr_status;
            $rrr = $remitaInvoices->rrr_number;
            $response              = remita_transaction_details($orderId);
            $txid= $orderId;


            if(isset($response['status'])){

                    $response_code      = $response['status'];
                    $response_message   = $response['message'];
                        if (isset($response['RRR'])){
                            $rrr = $response['RRR'];
                        }
        
                $chargeResponsecode    = $response['status'];
                $chargeAmount          = $response['amount'];
                
                    
                if (($chargeResponsecode == "00" || $chargeResponsecode == "01")) {

                    // transaction was successful...
                    // please check other things like whether you already gave value for this ref
                    // if the email matches the customer who owns the product etc
                    //Give Value and return to Success page
                    $payment_id = $txid; //Rrr OrderId
                    $bulk_fees=array();
                    // $params     = $this->session->userdata('params');
            
                    foreach ($params['student_fees_master_array'] as $fee_key => $fee_value) {
            
                        $json_array = array(
                            'amount'          =>  $fee_value['amount_balance'],
                            'date'            => date('Y-m-d'),
                            'amount_discount' => 0,
                            'amount_fine'     => $fee_value['fine_balance'],
                            'description'     => "Online fees deposit through Remita TXN ID: " . $payment_id,
                            'received_by'     => '',
                            'payment_mode'    => 'Remita',
                        );
                        $insert_fee_data = array(
                            'student_fees_master_id' => $fee_value['student_fees_master_id'],
                            'fee_groups_feetype_id'  => $fee_value['fee_groups_feetype_id'],
                            'amount_detail'          => $json_array,
                        );                 
                    $bulk_fees[]=$insert_fee_data;
                        //========
                        }

                        $send_to     = $params['guardian_phone'];
                        $inserted_id = $this->studentfeemaster_model->fee_deposit_bulk($bulk_fees, $send_to);
                        
                        //========================
                        $paymentDateFull    =   $response['paymentDate'];
                        $paymentDate        =   substr($paymentDateFull, 0, 10);   
                        $paymentTime        =   substr($paymentDateFull, 11);   
                        $paymentAmount      =   $chargeAmount;
                        
                            $remita_response = [
                                'payer_id'         => $params['student_id'],
                                'payer_model_type' => 2,
                                'rrrOrderId'       => $txid,
                                'rrr_number'       => $rrr,
                                'payment_date'     => $paymentDate,
                                'payment_time'     => $paymentTime,
                                'rrr_status'       => '01',
                                'payment_status'   => '1',
                                'total_amount_paid'=>$paymentAmount,
                                'transaction_ref'  => $txref,
                            ];

                        $updateRemitaInvoices    = $this->onlinestudent_model->paymentRemitaSuccess($remita_response);
                        // $return_detail     = $this->onlinestudent_model->paymentSuccess($gateway_response);

                        //=======================
                        if ($inserted_id) {
                            redirect(base_url("students/payment/successinvoice"));                     
                    } else {
                        redirect(base_url('students/payment/paymentfailed'));
                    }
                    
                } else {
                    //   $response['message'];
                    redirect(base_url("students/payment/paymentpending"));
                } 
                }
                
            }
                else {
                die('No or Invalid reference supplied');
            }
            }
}
