<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Remita extends Student_Controller {

    public $api_config = "";

    public function __construct() {
        parent::__construct();

        $api_config = $this->paymentsetting_model->getActiveMethod();
        $this->setting = $this->setting_model->get();
        $this->remita_service = $this->paymentsetting_model->getRemitaServices();
        $this->model_type = 2;
    }

    public function index() {

        $data = array();
        $data['params'] = $this->session->userdata('params');
        $data['setting'] = $this->setting;
        $data['api_error'] = array();
        $data['student_data'] = $this->student_model->get($data['params']['student_id']);
        $data['student_fees_master_array']=$data['params']['student_fees_master_array'];
        $this->load->view('student/remita/index', $data);
    }

    public function pay() {
      
        $this->form_validation->set_rules('phone', $this->lang->line('phone'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('email', $this->lang->line('email'), 'trim|required|xss_clean');
        $this->form_validation->set_rules('payment_mode', $this->lang->line('payment_mode'), 'trim|required|xss_clean');

        if ($this->form_validation->run() == false) {
         
            $data = array();
            $data['params'] = $this->session->userdata('params');
            $data['setting'] = $this->setting;
            $data['api_error'] = $data['api_error'] = array();
            $data['student_data'] = $this->student_model->get($data['params']['student_id']);
            $data['student_fees_master_array']=$data['params']['student_fees_master_array']; //Added by KBCS - Perhaps Oversight by the developers
            $this->load->view('student/remita/index', $data);
        } else {
          
            $details = $this->paymentsetting_model->getActiveMethod();
            // $api_secret_key = $details->api_secret_key;
            // $api_publishable_key = $details->api_publishable_key;

            $params = $this->session->userdata('params');
            $data = array();
            $student_id = $params['student_id'];
            $data['total'] =number_format((float)($params['fine_amount_balance']+$params['total']), 2, '.', '');
            $data['symbol'] = $params['invoice']->symbol;
            $data['currency_name'] = $params['invoice']->currency_name;
            $data['name'] = $params['name'];
            $data['guardian_phone'] = $params['guardian_phone'];
          
            $paymentBranch      = $this->input->post('payment_mode'); //"Bank Branch";
            $reference          = $student_id; // Student ID or Fees ID(2)
            $model_type         = 2; // Registration
            $txref = time().uniqid(); // ensure you generate unique references per transaction.
    

            /* Commented for now. this will work for application only but the query can not work for student registration bcos of multiple entries
            $checkRrr  = $this->onlinestudent_model->checkRemitaInvoiceExist($reference, $model_type);
            
            if($checkRrr){
                
                if($paymentBranch !== 'Bank'){
    
                    redirect("https://login.remita.net/remita/onepage/biller/$checkRrr/payment.spa");
                }else{
                    redirect("https://login.remita.net/remita/exapp/api/v1/send/api/print/billsvc/biller/$checkRrr/printinvoiceRequest.pdf");
                }
    
            }
           */
           /*
            |-----------------------------------------------------------------------------------------------------------------------------
            | Remita Service id
            |-----------------------------------------------------------------------------------------------------------------------------
            |
            | This value is given by remita for each service
            | This value is selected from PaymentSchedule Model releted to RemitaService Model and it used when generating invoice
            |
            */
            $remitaServiceId          =  $this->remita_service->remita_code;
            $remitaServiceDescription =  $this->remita_service->description;
             /*
        |-----------------------------------------------------------------------------------------------------------------------------
        | Service charge
        |-----------------------------------------------------------------------------------------------------------------------------
        |
        | This value is amount to be charged by briatek
        | This value is also to be deducted from the above $totalAmount 
        | This value is to be sent to briatek's bank account
        |
        */
        $serviceCharge        = $this->remita_service->briatek_service_charge;
        // $serviceCharge        =     0; // To be query

         /*
        |-----------------------------------------------------------------------------------------------------------------------------
        | Client's Bank Details
        |-----------------------------------------------------------------------------------------------------------------------------
        |
        | This is the client bank account details which include account name, account number, and cbn code
        | These mentioned details are used for sending the money to client's bank account
        |
        */
        $clientAccountName     =  $this->remita_service->client_acc_name;
        $clientAccountNumber   =  $this->remita_service->client_acc_no;
        $clientCbnCode         =  $this->remita_service->client_cbn_bank_code;
        /*
        |-----------------------------------------------------------------------------------------------------------------------------
        |  Briatek's Bank Details
        |-----------------------------------------------------------------------------------------------------------------------------
        |
        | This is the briatek's bank account details which include account name, account number, and cbn code
        | These mentioned details are used for sending  amount of the above service charged to briatek's bank account
        |
        */
        $briatekAccountName     =  $this->remita_service->briatek_acc_name;
        $briatekAccountNumber   =  $this->remita_service->briatek_acc_no;
        $briatekCbnCode         =  $this->remita_service->briatek_cbn_bank_code;
          /*
        |-----------------------------------------------------------------------------------------------------------------------------
        |  Client's REMITA Certified Merchant API Details
        |-----------------------------------------------------------------------------------------------------------------------------
        |
        | These are client details collected from remita and calling from RemitaMerchantInfo Model 
        | 
        |
        */
        $merchantId         = $details->api_publishable_key;
        $apiKey             = $details->api_secret_key;      
        // Variariable 'disapear' refers to online admission id. Added my KBCS  
 /*
        |-------------------------------------------------------------------------------------------------
        | Payer Details
        |-------------------------------------------------------------------------------------------------
        |
        | This is an array which content the datails above the payer e.g Payer name, Payer email, Payer phone, etc
        |
        */
        $redirect_url       = base_url() . 'students/remita/success?txref='.$txref; // Set your own redirect URL
        $payerName          = $data['name'];
        $payerId            = $reference;
        $payerModelType     = $model_type; // School Fees = 2
        $payerEmail         = $this->input->post('email');
        $payerPhone         = $this->input->post('phone');
        $totalAmount        = $data['total'];
        /*
        |-----------------------------------------------------------------------------------------------------------------------------
        |  Client's Amount
        |-----------------------------------------------------------------------------------------------------------------------------
        |
        | This is the value of amount which client received 
        | This value is is calculated as total amount less service charge
        |
        */
        
        $clientAmount           =   $totalAmount - $serviceCharge;
       

   /*
        |-------------------------------------------------------------------------------------------------
        | Remita API's Code
        |-------------------------------------------------------------------------------------------------
        |
        | The following code was given by remita except we put the needed values where necessary 
        |
        */
        define("MERCHANTID", $merchantId);
        define("SERVICETYPEID",$remitaServiceId);
        define("APIKEY", $apiKey);
        // define("GATEWAYURL", env("GATEWAYURL"));
        // define("GATEWAYRRRPAYMENTURL", env("GATEWAYRRRPAYMENTURL"));
        // define("CHECKSTATUSURL", env("CHECKSTATUSURL"));
        define("GATEWAYURL", "https://login.remita.net/remita/ecomm/split/init.reg");
        define("GATEWAYRRRPAYMENTURL", "https://login.remita.net/remita/ecomm/finalize.reg");
        define("CHECKSTATUSURL", "https://login.remita.net/remita/ecomm");
        define("PATH", 'http://'.$_SERVER['HTTP_HOST']."/invoice-remitas");

        $rrrTime            =   date("h:i:s a");
        $datTime            =   date("Y-m-d");
        $timeSammp          =   DATE("dmyHis");		
        $orderId            =   $timeSammp;


        $responseurl =  $redirect_url;
        $hash_string = MERCHANTID . SERVICETYPEID . $orderId . $totalAmount . $responseurl . APIKEY;
        $hash = hash('sha512', $hash_string);
        $itemtimestamp = $timeSammp;
        $itemid1="itemid1";
        $itemid2="34444".$itemtimestamp;
        $itemid3="8694".$itemtimestamp;
        $beneficiaryName        =   $clientAccountName;
        $beneficiaryName2       =   $briatekAccountName;
        $beneficiaryAccount     =   $clientAccountNumber;
        $beneficiaryAccount2    =   $briatekAccountNumber;
        $bankCode               =   $clientCbnCode;
        $bankCode2              =   $briatekCbnCode;
        $beneficiaryAmount      =   $clientAmount;
        $beneficiaryAmount2     =   $serviceCharge;
        $deductFeeFrom=1;
        $deductFeeFrom2=0;
        //The JSON data.
        $content = '{"merchantId":"'. MERCHANTID
        .'"'.',"serviceTypeId":"'.SERVICETYPEID
        .'"'.",".'"totalAmount":"'.$totalAmount
        .'","hash":"'. $hash
        .'"'.',"orderId":"'.$orderId
        .'"'.",".'"responseurl":"'.$responseurl
        .'","payerName":"'. $payerName
        .'"'.',"payerEmail":"'.$payerEmail
        .'"'.",".'"payerPhone":"'.$payerPhone
        .'","lineItems":[
        {"lineItemsId":"'.$itemid1.'","beneficiaryName":"'.$beneficiaryName.'","beneficiaryAccount":"'.$beneficiaryAccount.'","bankCode":"'.$bankCode.'","beneficiaryAmount":"'.$beneficiaryAmount.'","deductFeeFrom":"'.$deductFeeFrom.'"},
        {"lineItemsId":"'.$itemid2.'","beneficiaryName":"'.$beneficiaryName2.'","beneficiaryAccount":"'.$beneficiaryAccount2.'","bankCode":"'.$bankCode2.'","beneficiaryAmount":"'.$beneficiaryAmount2.'","deductFeeFrom":"'.$deductFeeFrom2.'"}
        ]}';
        $curl = curl_init(GATEWAYURL);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER,
        array("Content-type: application/json"));
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $content);
        $json_response = curl_exec($curl);
        $status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
        $jsonData = substr($json_response, 6, -1);
        $response = json_decode($jsonData, true);
        $statuscode = $response['statuscode'];
        $statusMsg = $response['status'];
             
        if($statuscode=='025'){
           
            $rrr = trim($response['RRR']);
            $new_hash_string = MERCHANTID . $rrr . APIKEY;
            $new_hash = hash('sha512', $new_hash_string);
            
            /**
             * Store Genereted Details 
             */
         
         
              $gateway_response =  [
                'transaction_ref'       =>  $txref,
                'params'                =>  serialize($params), //https://stackoverflow.com/questions/10686333/save-array-in-mysql-database
                'payer_id'              =>  $reference, // Online Admission ID
                'payer_model_type'      =>  $payerModelType, // 1 = Online Admission
                'name'                  =>  $payerName,
                'phone_number'          =>  $payerPhone,
                'email'                 =>  $payerEmail,
                'rrr_number'            =>  $rrr,
                'rrrOrderID'            =>  $orderId,
                'rrr_status'            =>  $statuscode,
                'payment_status'        =>  '0',
                'actual_schedule_amount'=>  $totalAmount,
                'is_schedule'           =>  1,
                'amount_paid'           =>  $totalAmount,
                'service_charge'        =>  $serviceCharge,
                'client_amount'         =>  $clientAmount,
                'service_code'          =>  $remitaServiceId,
                'service_description'   =>  $remitaServiceDescription,
                'client_account_no'     =>  $clientAccountNumber,
                'briatek_account_no'    =>  $briatekAccountNumber,
                'generated_date'        =>  date("Y-m-d"),
                'generated_time'        =>  date("h:i:s A"),
                'payment_branch'        =>  $paymentBranch,
                'status'                =>  '1',
                'is_active'             =>  '1'
             ];
             $invoiceRemitaStatus                      = $this->onlinestudent_model->addRemitaInvoice($gateway_response);

            if($invoiceRemitaStatus){//Check if it store the details in the above model

                if($paymentBranch !="Bank")//it means other payment option that may include atm, ussd, etc.
                {
                     redirect("https://login.remita.net/remita/onepage/biller/$rrr/payment.spa");
                }

                elseif($paymentBranch =="Bank")//it means Bank Branch
                {
                     redirect("https://login.remita.net/remita/exapp/api/v1/send/api/print/billsvc/biller/$rrr/printinvoiceRequest.pdf");
                }
                
                // return 200;
                // return response(["status"=>200, "message"=>$response['status'], "RRR"=>$rrr, "orderID"=>$response['orderID']]);

            }else{
                
                print("Refuse to store the generated rrr's details") ;
                // return response(["status"=>201, "message"=>"Refuse to store the generated rrr's details", "RRR"=>$rrr, "orderID"=>$response['orderID']]);

            }

        }else{
                print("Error Generating RRR - " .$statusMsg);
        } 
    }
  }
    public function success() {
        $details = $this->paymentsetting_model->getActiveMethod();
        $api_secret_key = $details->api_secret_key;
        
        if($this->session->userdata('params') == ''){
            // https://stackoverflow.com/questions/10686333/save-array-in-mysql-database
            $params =  unserialize($_GET['params']);
        }else{
            $params = $this->session->userdata('params');
        }
        
        $txref = $_GET['txref']; //This is Student ID also payer id provided payer model type = 1

         /*
        |-----------------------------------------------------------------------------------------------------------------------------
        |  Client's REMITA Certified Merchant API Details
        |-----------------------------------------------------------------------------------------------------------------------------
        |
        | These are client details collected from remita and calling from RemitaMerchantInfo Model 
        | 
        |
        */
        $merchantId         = $details->api_publishable_key;
        $apiKey             = $details->api_secret_key;         
        

    //    if (isset($_GET['txref'])) {
    //     if(isset($_GET['cancelled']) && $_GET['cancelled']=='true'){
    //         redirect(base_url("students/payment/paymentfailed"));
    //     }else{

        // $ref = $_GET['txref'];
        $amount=number_format((float)($params['fine_amount_balance']+$params['total']), 2, '.', ''); //Get the correct amount of your product
        $currency = $params['invoice']->currency_name; //Correct Currency from Server

        /*
        |-------------------------------------------------------------------------------------------------
        | Remita API's Code
        |-------------------------------------------------------------------------------------------------
        |
        | The following code was given by remita except we put the needed values where necessary 
        |
        */

        define("MERCHANTID", $merchantId); 
        define("APIKEY", $apiKey);
        define("CHECKSTATUSURL", "https://login.remita.net/remita/ecomm");
       
       
       //Verify Transaction
      function remita_transaction_details($orderIdStatus){
                
        $mert =  MERCHANTID;
        $api_key =  APIKEY;
        $concatString = $orderIdStatus . $api_key . $mert;
        $hash = hash('sha512', $concatString);
        $url 	= CHECKSTATUSURL . '/' . $mert  . '/' . $orderIdStatus . '/' . $hash . '/' . 'orderstatus.reg';
        //  Initiate curl
        $ch = curl_init();
        // Disable SSL verification
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        // Will return the response, if false it print the response
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // Set the url
        curl_setopt($ch, CURLOPT_URL,$url);
        // Execute
        $result=curl_exec($ch);
        // Closing
        curl_close($ch);
        $response = json_decode($result, true);
        return $response;
    } 

    $remitaInvoices        = $this->onlinestudent_model->getRemitaInvoices($txref);
    
        if($remitaInvoices){
           
            if($remitaInvoices->payment_status == 1) { // Avoid multiple update    
                redirect(base_url("students/payment/successinvoice"));
            }
            $orderId               = $remitaInvoices->rrrOrderId;
            $currentRrrStatus      = $remitaInvoices->rrr_status;
            $rrr = $remitaInvoices->rrr_number;
            $response              = remita_transaction_details($orderId);
            $txid= $orderId;


            if(isset($response['status'])){

                    $response_code      = $response['status'];
                    $response_message   = $response['message'];
                        if (isset($response['RRR'])){
                            $rrr = $response['RRR'];
                        }
        
                $chargeResponsecode    = $response['status'];
                $chargeAmount          = $response['amount'];
                
                    
                if (($chargeResponsecode == "00" || $chargeResponsecode == "01")) {

                    // transaction was successful...
                    // please check other things like whether you already gave value for this ref
                    // if the email matches the customer who owns the product etc
                    //Give Value and return to Success page
                    $payment_id = $txid; //Rrr OrderId
                    $bulk_fees=array();
                    // $params     = $this->session->userdata('params');
            
                    foreach ($params['student_fees_master_array'] as $fee_key => $fee_value) {
            
                        $json_array = array(
                            'amount'          =>  $fee_value['amount_balance'],
                            'date'            => date('Y-m-d'),
                            'amount_discount' => 0,
                            'amount_fine'     => $fee_value['fine_balance'],
                            'description'     => "Online fees deposit through Remita TXN ID: " . $payment_id,
                            'received_by'     => '',
                            'payment_mode'    => 'Remita',
                        );
                        $insert_fee_data = array(
                            'student_fees_master_id' => $fee_value['student_fees_master_id'],
                            'fee_groups_feetype_id'  => $fee_value['fee_groups_feetype_id'],
                            'amount_detail'          => $json_array,
                        );                 
                    $bulk_fees[]=$insert_fee_data;
                        //========
                        }

                        $send_to     = $params['guardian_phone'];
                        $inserted_id = $this->studentfeemaster_model->fee_deposit_bulk($bulk_fees, $send_to);
                        
                        //========================
                        $paymentDateFull    =   $response['paymentDate'];
                        $paymentDate        =   substr($paymentDateFull, 0, 10);   
                        $paymentTime        =   substr($paymentDateFull, 11);   
                        $paymentAmount      =   $chargeAmount;
                        
                            $remita_response = [
                                'payer_id'         => $params['student_id'],
                                'payer_model_type' => $this->model_type,
                                'rrrOrderId'       => $txid,
                                'rrr_number'       => $rrr,
                                'payment_date'     => $paymentDate,
                                'payment_time'     => $paymentTime,
                                'rrr_status'       => '01',
                                'payment_status'   => '1',
                                'total_amount_paid'=>$paymentAmount,
                                'transaction_ref'  => $txref,
                            ];

                        $updateRemitaInvoices    = $this->onlinestudent_model->paymentRemitaSuccess($remita_response);
                        // $return_detail     = $this->onlinestudent_model->paymentSuccess($gateway_response);

                        //=======================
                        if ($inserted_id) {
                            redirect(base_url("students/payment/successinvoice"));                     
                    } else {
                        redirect(base_url('students/payment/paymentfailed'));
                    }
                    
                } else {
                    //   $response['message'];
                    redirect(base_url("students/payment/paymentpending"));
                } 
                }
                
            }
                else {
                die('No or Invalid reference supplied');
            }
            }
       
}       
                