<?php defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------
| DATABASE CONNECTIVITY SETTINGS
| -------------------------------------------------------------------
| This file will contain the settings needed to access your database.
|
| For complete instructions please consult the 'Database Connection'
| page of the User Guide.
|
| -------------------------------------------------------------------
| EXPLANATION OF VARIABLES
| -------------------------------------------------------------------
|
|	['dsn']      The full DSN string describe a connection to the database.
|	['hostname'] The hostname of your database server.
|	['username'] The username used to connect to the database
|	['password'] The password used to connect to the database
|	['database'] The name of the database you want to connect to
|	['dbdriver'] The database driver. e.g.: mysqli.
|			Currently supported:
|				 cubrid, ibase, mssql, mysql, mysqli, oci8,
|				 odbc, pdo, postgre, sqlite, sqlite3, sqlsrv
|	['dbprefix'] You can add an optional prefix, which will be added
				|				 to the table name when using the  Query Builder class
|	['pconnect'] TRUE/FALSE - Whether to use a persistent connection
|	['db_debug'] TRUE/FALSE - Whether database errors should be displayed.
|	['cache_on'] TRUE/FALSE - Enables/disables query caching
|	['cachedir'] The path to the folder where cache files should be stored
|	['char_set'] The character set used in communicating with the database
|	['dbcollat'] The character collation used in communicating with the database
|				 NOTE: For MySQL and MySQLi databases, this setting is only used
| 				 as a backup if your server is running PHP < 5.2.3 or MySQL < 5.0.7
|				 (and in table creation queries made with DB Forge).
| 				 There is an incompatibility in PHP with mysql_real_escape_string() which
| 				 can make your site vulnerable to SQL injection if you are using a
| 				 multi-byte character set and are running versions lower than these.
| 				 Sites using Latin-1 or UTF-8 database character set and collation are unaffected.
|	['swap_pre'] A default table prefix that should be swapped with the dbprefix
|	['encrypt']  Whether or not to use an encrypted connection.
|
|			'mysql' (deprecated), 'sqlsrv' and 'pdo/sqlsrv' drivers accept TRUE/FALSE
|			'mysqli' and 'pdo/mysql' drivers accept an array with the following options:
|
|				'ssl_key'    - Path to the private key file
|				'ssl_cert'   - Path to the public key certificate file
|				'ssl_ca'     - Path to the certificate authority file
|				'ssl_capath' - Path to a directory containing trusted CA certificats in PEM format
|				'ssl_cipher' - List of *allowed* ciphers to be used for the encryption, separated by colons (':')
|				'ssl_verify' - TRUE/FALSE; Whether verify the server certificate or not ('mysqli' only)
|
|	['compress'] Whether or not to use client compression (MySQL only)
|	['stricton'] TRUE/FALSE - forces 'Strict Mode' connections
|							- good for ensuring strict SQL while developing
|	['ssl_options']	Used to set various SSL options that can be used when making SSL connections.
|	['failover'] array - A array with 0 or more data for connections if the main should fail.
|	['save_queries'] TRUE/FALSE - Whether to "save" all executed queries.
| 				NOTE: Disabling this will also effectively disable both
| 				$this->db->last_query() and profiling of DB queries.
| 				When you run a query, with this setting set to TRUE (default),
| 				CodeIgniter will store the SQL statement for debugging purposes.
| 				However, this may cause high memory usage, especially if you run
| 				a lot of SQL queries ... disable this to avoid that problem.
|
| The $active_group variable lets you choose which connection group to
| make active.  By default there is only one group (the 'default' group).
				|
| The $query_builder variables lets you determine whether or not to load
| the query builder class.
						*/
$active_group = 'default';
$query_builder = TRUE;

// Add some sanitization for $data

// Contact a central database (which stores information about all clients
 
$host = 'localhost';
$username = 'basicng_root';
$password = 'iq160acada';
$dbname = 'basicng_owner';

try {
    $dbh = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    // echo "Connected to $dbname at $host successfully.";
} catch (PDOException $pe) {
    die("Could not connect to the database $dbname :" . $pe->getMessage());
}

$sql = "SELECT subdomain, dbusername,dbname,dbpassword FROM clients WHERE subdomain = :subdomain LIMIT 1";
$subdomain = CLIENT;
$sth = $dbh->prepare($sql);
$sth->bindparam(':subdomain', $subdomain);
$sth->execute();
$db_result= $sth->fetch();

// $id = 4;
// $stmt = $dbh->prepare("SELECT name FROM mytable WHERE id=? LIMIT 1"); 
// $stmt->execute([$id]); 
// $row = $stmt->fetch();


// We are done with PDO for this purpose so free up some resources!


// Get client's DB details (make sure $subdomain is already sanitized)
 
// You can add caching code here to skip the above DB call
 
if (empty($db_result['subdomain'])) {
    // If the client does not exist i.e. the end-user types the wrong sub-domain
    echo "Oops! Sorry, we are unable to find you! Please email us at support@briatek.com.ng";
    exit();
}else{
	$dbname   	= $db_result['dbname'];
	$dbusername = $db_result['dbusername'];
	$dbpassword = $db_result['dbpassword'];

	if($dbname == ''){
		echo "Oops! Sorry, we are unable to find you! Please email us at support@briatek.com.ng";
        exit();
	}
	if($dbusername == ''){
		$dbusername = 'basicng_root';
	}
	if($dbpassword == ''){
	 	$dbpassword = 'iq160acada';
	}
}

$dbh = null;
unset($dbh);


$db['default'] = array(
	'dsn'	=> '',
	'hostname' => 'localhost',
	'username' => $dbusername,
	'password' => $dbpassword,
	'database' => $dbname,
	'dbdriver' => 'mysqli',
	'dbprefix' => '',
	'pconnect' => FALSE,
	'db_debug' => (ENVIRONMENT !== 'production'),
	'cache_on' => FALSE,
	'cachedir' => '',
	'char_set' => 'utf8',
	'dbcollat' => 'utf8_general_ci',
	'swap_pre' => '',
	'encrypt' => FALSE,
	'compress' => FALSE,
	'stricton' => FALSE,
	'failover' => array(),
	'save_queries' => TRUE
);
